/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.ChangeConsoleIntCodeConstants;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.hwmca.xfw.updates.UpdateRange;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class StartChgEndChgBean
extends PanelBean
implements ChangeConsoleIntCodeConstants,
UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCLSCBT";
    private static final String TRACE_MASKF = "XMCLSCBF";
    private static final String TRACE_MASKD = "XMCLSCBD";
    private List m_idECChgTable = null;
    private ColumnDescriptor[] m_cdECChgTableStructure = null;
    private int[] m_iECChgTableSelection;
    private static final int NUM_COLUMNS = 3;
    private static final int NUM_ROWS = 50;
    private static final String TABLE_NAME = "ECChgTable";
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "StartChgEndChgBean");

    public StartChgEndChgBean() {
        this.setBeanName("StartChgEndChgPanel");
    }

    public ColumnDescriptor[] getECChgTableRowStructure() {
        Trace.trace(TRACE_MASKD, "<> StartChgEndChgBean.getECChgTableRowStructure()");
        return this.m_cdECChgTableStructure;
    }

    public int getECChgTableRowStatus() {
        Trace.trace(TRACE_MASKD, "<> StartChgEndChgBean.getECChgTableRowStatus()");
        return 3;
    }

    public int getECChgTableRowCount() {
        Trace.trace(TRACE_MASKD, "<> StartChgEndChgBean.getECChgTableRowCount()");
        return 50;
    }

    public ItemDescriptor[] getECChgTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "<> StartChgEndChgBean.getECChgTableRowAt(), index: " + index);
        String[] stringArrayRow = (String[])this.m_idECChgTable.get(index);
        ItemDescriptor[] rowData = new ItemDescriptor[3];
        rowData[0] = new ItemDescriptor("EngChgPCol" + index, stringArrayRow[0]);
        String outLevel = stringArrayRow[1];
        int levelLength = outLevel.length();
        if (levelLength > 0 && levelLength < 3) {
            outLevel = "000".substring(0, 3 - levelLength) + outLevel;
        }
        rowData[1] = new ItemDescriptor("StartChgCol" + index, outLevel);
        outLevel = stringArrayRow[2];
        levelLength = outLevel.length();
        if (levelLength > 0 && levelLength < 3) {
            outLevel = "000".substring(0, 3 - levelLength) + outLevel;
        }
        rowData[2] = new ItemDescriptor("EndChgCol" + index, outLevel);
        return rowData;
    }

    public void setECChgTableRowAt(int index, ItemDescriptor[] items) {
        Trace.trace(TRACE_MASKT, "<> StartChgEndChgBean.setECChgTableRowAt(), index: " + index);
        String[] stringArrayRow = new String[3];
        for (int i = 0; i < 3; ++i) {
            Trace.trace(TRACE_MASKD, "[setECChgTableRowAt()] item #" + i + ": " + items[i]);
            stringArrayRow[i] = items[i].getTitle().trim().toUpperCase();
        }
        this.m_idECChgTable.set(index, stringArrayRow);
    }

    public int[] getECChgTableSelection() {
        Trace.trace(TRACE_MASKD, "<> StartChgEndChgBean.getECChgTableSelection()");
        return this.m_iECChgTableSelection;
    }

    public void setECChgTableSelection(int[] selected) {
        Trace.trace(TRACE_MASKD, "<> StartChgEndChgBean.setECChgTableSelection()");
        for (int i = 0; i < selected.length; ++i) {
            Trace.trace(TRACE_MASKD, "[setECChgTableSelection()] selected row #" + i + ": " + selected[i]);
        }
        this.m_iECChgTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "<> StartChgEndChgBean.load()");
        if (null == this.m_idECChgTable) {
            this.m_idECChgTable = new ArrayList(50);
            for (int i = 0; i < 50; ++i) {
                this.m_idECChgTable.add(new String[]{"", "", ""});
            }
        }
        this.setECChgTableSelection(new int[0]);
    }

    public void initializeWithServerData(List data) {
        int numDefaultRows;
        Trace.trace(TRACE_MASKT, "-> StartChgEndChgBean.initializeWithServerData()");
        this.m_idECChgTable = new ArrayList(50);
        if (null != data) {
            Iterator rowIterator = data.iterator();
            while (rowIterator.hasNext()) {
                UpdateLevel rowData = (UpdateLevel)rowIterator.next();
                String ecNumber = rowData.getUpdateableComponentECNumber();
                int intStartLevel = rowData.getLevel();
                this.m_idECChgTable.add(new String[]{ecNumber, Integer.toString(intStartLevel), "ALL"});
            }
            numDefaultRows = data.size();
        } else {
            numDefaultRows = 0;
            Trace.trace(TRACE_MASKD, "[initializeWithServerData()] The List object passed in is NULL.");
        }
        Trace.trace(TRACE_MASKD, "[load()] The number of rows filled with default data: " + numDefaultRows);
        for (int i = numDefaultRows; i < 50; ++i) {
            this.m_idECChgTable.add(new String[]{"", "", ""});
        }
        Trace.trace(TRACE_MASKT, "<- StartChgEndChgBean.initializeWithServerData()");
    }

    public void clearTable() {
        Trace.trace(TRACE_MASKT, "<> StartChgEndChgBean.clearTable()");
        Collections.fill(this.m_idECChgTable, new String[]{"", "", ""});
        this.setECChgTableSelection(new int[0]);
        this.getUserTaskManager().refreshElement(TABLE_NAME);
    }

    private void removeEmptyTableRowsBeforeData() {
        Trace.trace(TRACE_MASKT, "<> StartChgEndChgBean.removeEmptyTableRowsBeforeData()");
        Iterator rowIterator = this.m_idECChgTable.iterator();
        while (rowIterator.hasNext()) {
            String[] rowData = (String[])rowIterator.next();
            String ecNumber = rowData[0];
            String startLevel = rowData[1];
            String endLevel = rowData[2];
            if (ecNumber.length() != 0 || startLevel.length() != 0 || endLevel.length() != 0) continue;
            rowIterator.remove();
        }
        for (int i = this.m_idECChgTable.size(); i < 50; ++i) {
            this.m_idECChgTable.add(i, new String[]{"", "", ""});
        }
        this.setECChgTableSelection(new int[0]);
        this.getUserTaskManager().refreshElement(TABLE_NAME);
    }

    private String findDuplicateECNumber() {
        Trace.trace(TRACE_MASKT, "<> StartChgEndChgBean.isDuplicateECNumber()");
        String duplicate = null;
        HashSet<String> hs = new HashSet<String>(50);
        Iterator rowIterator = this.m_idECChgTable.iterator();
        while (rowIterator.hasNext()) {
            String[] rowData = (String[])rowIterator.next();
            String ecNumber = rowData[0];
            if (ecNumber.length() == 0) continue;
            if (hs.contains(ecNumber)) {
                duplicate = ecNumber;
                break;
            }
            hs.add(ecNumber);
        }
        return duplicate;
    }

    private void showMessage(String titleKey, String messageKey) {
        Trace.trace(TRACE_MASKT, "<> StartChgEndChgBean.showMessage");
        try {
            CommonMsgApp.showMessageBox(this.getUserTaskManager(), new BaseMessageTitle(titleKey), new BaseMessageText(messageKey));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "[showMessage] Exception working with message box: ", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void panelAction(TaskActionEvent event) {
        block25: {
            Trace.trace(TRACE_MASKT, "-> StartChgEndChgBean.panelAction()");
            boolean gotError = false;
            try {
                String command = event.getActionCommand();
                Trace.trace(TRACE_MASKF, "[panelAction()] action command: '" + command + "'.");
                if (command.equalsIgnoreCase("CANCEL")) {
                    Trace.trace(TRACE_MASKD, "[panelAction()] CANCEL action command was received.");
                    this.dispose();
                    break block25;
                }
                if (command.equalsIgnoreCase("OKButton")) {
                    this.getUserTaskManager().storeAllElements();
                    this.removeEmptyTableRowsBeforeData();
                    ArrayList<void> urList = new ArrayList<void>();
                    Iterator rowIterator = this.m_idECChgTable.iterator();
                    while (rowIterator.hasNext()) {
                        void var10_12;
                        UpdateRange ur;
                        int intStartLevel;
                        String endLevel;
                        String ecNumber;
                        block26: {
                            String[] rowData = (String[])rowIterator.next();
                            ecNumber = rowData[0];
                            String startLevel = rowData[1];
                            endLevel = rowData[2];
                            Trace.trace(TRACE_MASKD, "[panelAction()] EC number: '" + ecNumber + "', start: '" + startLevel + "', end: '" + endLevel + "'");
                            if (ecNumber.length() == 0) {
                                if (startLevel.length() == 0 && endLevel.length() == 0) break;
                                this.showMessage("MCL8027", "MCL0028");
                                gotError = true;
                                break;
                            }
                            if (startLevel.length() == 0) {
                                this.showMessage("MCL8027", "MCL0029");
                                gotError = true;
                                break;
                            }
                            if (endLevel.length() == 0) {
                                this.showMessage("MCL8027", "MCL0034");
                                gotError = true;
                                break;
                            }
                            try {
                                intStartLevel = Integer.parseInt(startLevel);
                                if (intStartLevel == 0) {
                                    this.showMessage("MCL8027", "MCL0029");
                                    gotError = true;
                                }
                                break block26;
                            }
                            catch (NumberFormatException nfe) {
                                this.showMessage("MCL8027", "MCL0033");
                                gotError = true;
                            }
                            break;
                        }
                        if (endLevel.equalsIgnoreCase("ALL")) {
                            ur = new UpdateRange(ecNumber, intStartLevel, -1);
                        } else {
                            try {
                                int intEndLevel = Integer.parseInt(endLevel);
                                if (intStartLevel > intEndLevel) {
                                    this.showMessage("MCL8027", "MCL0027");
                                    gotError = true;
                                    break;
                                }
                                ur = new UpdateRange(ecNumber, intStartLevel, intEndLevel);
                            }
                            catch (NumberFormatException nfe) {
                                this.showMessage("MCL8027", "MCL0033");
                                gotError = true;
                                break;
                            }
                        }
                        urList.add(var10_12);
                    }
                    if (!gotError) {
                        if (urList.isEmpty()) {
                            this.showMessage("MCL8032", "MCL0032");
                        } else {
                            String duplicate = this.findDuplicateECNumber();
                            if (null != duplicate) {
                                try {
                                    CommonMsgApp.showMessageBox(this.getUserTaskManager(), new BaseMessageTitle("MCL8027"), new BaseMessageText("MCL0031", new String[]{duplicate}));
                                }
                                catch (HException e) {
                                    Trace.trace(TRACE_MASKF, "[showMessage] Exception working with message box: ", e);
                                }
                            } else {
                                PanelTaskletRequest request = new PanelTaskletRequest();
                                request.setData("event", event);
                                request.setData("userData", urList);
                                this.postTaskletRequest(request);
                            }
                        }
                    }
                    break block25;
                }
                if (command.equalsIgnoreCase("ClearButton")) {
                    this.clearTable();
                } else {
                    Trace.trace(TRACE_MASKF, "[panelAction()] Ignore the unexpected action command.");
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "[panelAction()] exception: " + e);
                new FrameworkLog(classLogInfo, -4350, e).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- StartChgEndChgBean.panelAction()");
    }
}

